<?php
require_once('server_config.php');
require_once('html_reader.php');
require_once('error_log.php');
$pdo = require 'db_config.php';

$category_sk = $_POST["categorySk"];
$url = $_POST["page_url"];

$objLog =  new LogFile();
$objLog->set_name($url."-state");

//foreach state, scrape url and then get search description
$cnt = count($state);
echo "state count - ".$cnt;
for($i=0; $i < $cnt; $i++)
{
    $state_url = $url."category/".$state[$i]."/";
    echo $state_url."<br/>";
    $htmlContent = get_html_content($state_url);

    // check for errors
    if (str_contains($htmlContent,"cURL error"))
    {
        $message = "cURL error for URL - : " .$state_url. "\r\n". $htmlContent;
        $objLog->write_to_file($message);
    }
    // create a new Simple HTML DOM instance
    $html = str_get_html($htmlContent);

    //fetch all companies in the state search page
    $companies = $html->find(".adv");
    // create an empty product array to collect the extracted data
    $comData = array();
    try {
        // loop through the product container to extract its elements
        foreach ($companies as $company) {
            // find the name elements within the current product element
            $m_client_name = $company->find('span[itemprop=name]', 0)->plaintext;
            $ad_desc = "";

                $ad_description = $company->find('p');
                foreach ($ad_description as $ad)
                    $ad_desc .= " " . $ad;

            echo "client name". $m_client_name;
            echo "  --- desc". $ad_desc;
            echo "<br/>********************************<br/>";

            // check if the target elements exist with the required attributes
            if ($m_client_name)
            {
                try {
                    $sql = 'UPDATE dbo."M_ADVERTISEMENT" SET "SEARCH_DESCRIPTION"=:M_SRCH_DESC WHERE "M_CATEGORY_SK"=:M_CATEGORY_SK AND "CLIENT_NAME"=:M_CLIENT_NAME';
                    $stmt = $pdo->prepare($sql);
                        $stmt->execute([
                            ':M_CLIENT_NAME' => trim($m_client_name),
                            ':M_CATEGORY_SK' => $category_sk,
                            ':M_SRCH_DESC' => trim($ad_desc)
                        ]);
                    $message .= "State Search Description Updated successfully with  !". trim($m_client_name)." - ".  $category_sk. "\n\r". trim($ad_desc);
                } catch (PDOException $e) {
                    $err = "<br/>Error in updating Advertisement Search Description: " . $e->getMessage();
                    $objLog->write_to_file($err);
                }
            }
        }
    }
    catch (Exception $e) {
        $message = "<br/>Error in parsing Advertisement: " . $e->getMessage();
        $objLog->write_to_file($message);
    }
}
return $message;
?>
