<?php
// include the Simple HTML DOM parser library
include_once("simple_html_dom.php");

function get_html_content($url)
{
    // initialize a cURL session
    $curl = curl_init();

    // set the website URL
    curl_setopt($curl, CURLOPT_URL, $url);

    // return the response as a string
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);

    // follow redirects
    curl_setopt($curl, CURLOPT_FOLLOWLOCATION, true);

    // ignore SSL verification (not recommended in production)
    curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);

    // execute the cURL session
    $htmlContent = curl_exec($curl);

    // check for errors
    if ($htmlContent === false) {
        // handle the error
        $error = curl_error($curl);
        $htmlContent = "cURL error: " . $error;

    }

    // close cURL session
    curl_close($curl);
    return $htmlContent;
}