<?php
require_once('server_config.php');
require_once('html_reader.php');
$pdo = require 'db_config.php';
global $objLog;

// specify the target website's URL
/*
$url = "https://load-cells.org/";
$state_url = "https://load-cells.org/category/alabama/";
$page2_url = "https://load-cells.org/more-load-cell-manufacturer-listings/";
*/
$adv = array();
// create a function to scrape product data from a given URL
function adv_scraper($url, $m_category_sk, $page)
{
    global $message;
    global $objLog;
    $htmlContent = get_html_content($url);
    // check for errors
    if (str_contains($htmlContent, "cURL error")) {
       $message = "cURL error: " . $htmlContent;
        $objLog->write_to_file($message);
        exit;
    }
    // create a new Simple HTML DOM instance[
    $page_html = str_get_html($htmlContent);
    process_adv_html($page_html , $m_category_sk, $page);
}

function process_adv_html($html , $m_category_sk, $page)
{
    global $message;
    global $objLog;
    if($page==3) //state search
    {
        $adv_text = $html->find('div.section.adv-logo.top p', 0); // Get the first matching <p> tag
        //update category table with advt text
        updt_state_search_desc($m_category_sk, $adv_text);
        //we also need to update advertisement table  state search description with company profile description from the state page
        //loop through all states, update description for each companies


    }
    else {
        // obtain the product containers
        $companies = $html->find(".adv");
        // create an empty product array to collect the extracted data
        $comData = array();
        try {
            // loop through the product container to extract its elements
            foreach ($companies as $company) {
                // find the name elements within the current product element
                $m_client_name = $company->find('span[itemprop=name]', 0)->plaintext;
                $m_address = $company->find('span[itemprop=addressLocality]', 0)->plaintext;
                $m_phone = $company->find('span[itemprop=telephone]', 0)->plaintext;
                $ad_desc = "";
                if($page==1)
                    $ad_desc = $company->find('p[itemprop=description]', 0)->plaintext;
                else if ($page==2)
                {
                    $ad_description = $company->find('p');
                    foreach ($ad_description as $ad)
                        $ad_desc .= " " . $ad;
                }
                $link = $company->find('a');

                // check if the target elements exist with the required attributes
                if ($m_client_name && $m_address && $m_phone)
                {
                    // create an array of the extracted data
                    $companyInfo = array(
                        "CLIENT_NAME" => $m_client_name,
                        "M_CATEGORY_SK" => $m_category_sk,
                        /*"ADDRESS" =>$m_address,*/
                        "PAGE" => $page,
                        "PHONE" => $m_phone,
                        "AD_DESCRIPTION" => $ad_desc,
                        "USER_CREATED" => 'Sumi',
                        "DATE_CREATED" => date("Y-m-d h:i:s")
                    );
                    // append the extracted data to the empty product array
                    $companyData[] = $companyInfo;
                }
            }

            if (count($companyData) > 0) {
                insert_to_adMic($companyData);
            }
            //if page2 page, update category table
            if($page == 2)
            {
               $p2_dis_name = $html->find('.container h1', 0)->plaintext;
               // $message .= "page2 display name". $p2_dis_name;
               $p2_short_desc = $html->find('.container h2', 0)->plaintext;
               // $message .= "page2 short desc". $p2_short_desc;
                updt_cat_p2Elem($m_category_sk, $p2_dis_name, $p2_short_desc);

            }
        } catch (Exception $e) {
            $message = "<br/>Error in parsing Advertisement: " . $e->getMessage();
            $objLog->write_to_file($message);
        }
    }

}

function updt_cat_p2Elem($m_category_sk, $p2_dis_name, $p2_short_desc)
{
    global $pdo;
    global $message;
    global $objLog;
    try
    {
        $sql = 'UPDATE dbo."M_CATEGORY" SET "P2_H1DISPLAY_NAME"=:M_P2H1_NAME, "P2_SHORT_DESCRIPTION"=:M_P2_SHORT WHERE "M_CATEGORY_SK"=:M_CATEGORY_SK';

        $stmt = $pdo->prepare($sql);
        $stmt->execute([':M_P2H1_NAME' => $p2_dis_name,
            ':M_P2_SHORT' => $p2_short_desc,
            'M_CATEGORY_SK' => $m_category_sk
        ]);
    }
    catch (Exception $e)
    {
        $message = "<br/>Error in updating caregory table with page2 elements: " . $e->getMessage();
        $objLog->write_to_file($message);
    }
}

function  updt_state_search_desc($m_category_sk, $adv_text)
{
    global $pdo;
    global $message;
    global $objLog;
    try
    {
        $objLog->write_to_file("<br/>State Search Desc - ". $adv_text);
        $sql = 'UPDATE dbo."M_CATEGORY" SET "STATESEARCH_DESCRIPTION"=:M_AD_DESCRIPTION WHERE "M_CATEGORY_SK"=:M_CATEGORY_SK';

        $stmt = $pdo->prepare($sql);
        $stmt->execute([':M_AD_DESCRIPTION' => $adv_text,
            'M_CATEGORY_SK' => $m_category_sk
        ]);
    }
    catch (Exception $e)
    {
         $message = "<br/>Error in updating State Search Desc: " . $e->getMessage();
        $objLog->write_to_file($message);
    }
}

function insert_to_adMic($companyData)
{
    global $pdo;
    global $message;
    global $objLog; 
    try {
        // Prepare the insert statement
        $sql = 'INSERT INTO dbo."M_ADVERTISEMENT" ("CLIENT_NAME", "M_CATEGORY_SK", "PHONE","AD_DESCRIPTION", "PAGE","USER_CREATED","DATE_CREATED")
            VALUES (:M_CLIENT_NAME, :M_CATEGORY_SK,  :M_PHONE, :M_AD_DESCRIPTION, :PAGE, :M_USER_CREATED,:M_DATE_CREATED )';
        $stmt = $pdo->prepare($sql);
        //$stmt->debugDumpParams();
        foreach ($companyData as $adInfo) {
            $stmt->execute([
                ':M_CLIENT_NAME' => $adInfo['CLIENT_NAME'],
                ':M_CATEGORY_SK' => $adInfo['M_CATEGORY_SK'],
                ':M_PHONE' => $adInfo['PHONE'],
                ':M_AD_DESCRIPTION' => $adInfo['AD_DESCRIPTION'],
                ':PAGE' =>  $adInfo['PAGE'],
                ':M_USER_CREATED' => 'Sumi',
                ':M_DATE_CREATED' => date('Y-m-d h:i:s')
            ]);
        }
        $message = "Advertisement Data inserted successfully!";
    } catch (PDOException $e) {
        $message = "<br/>Error in inserting Advertisement: " . $e->getMessage();
    }
    $objLog->write_to_file($message);
    return $message;
}
// clean up resources
//$html->clear();
?>
